# 2020-07-02 (FR)
# Este ejemplo muestra el envio de registros histricos usan un modem Iridium SBD (ITAS/EDGE) conectado a un puerto serie del GRD/cLAN;

#Inicio;
start
{
	a=0; b=0;
	timer m,1000; #El primer chequeo se hace un segundo despues de iniciar el script;
	timer n,30000; #Timer de envio de mensajes de estado;
};

#Lee estado de modem satelital; 
read_io 55,a,0;

#Una vez cada dos minutos envia los datos que haya en memoria (maximo 39 registros por envio);
check_timer m
{
	read_io 8,c,0; #Si hay registros en memoria hace el envio;
	if c>0 {
	    if a!-1 {
			write_io 54,0,0; #Envia por modem satelital los registros en memoria;
			timer m,120000;  #El prximo envio lo hace en 2 minutos;
			#timer m,7200000;  #El prximo envio lo hace en 120 minutos;
		};
	};	
};

#El script podria terminar aqui. Lo que sigue a continuacin es la lectura del estado del envio por modem satelital y el envio de este estado por la consola de 'traces' del Script Programmer;
if a=-7 { z='- No envia, conectado al Middleware (7)'; };
if a=-6	{ z='- Error enviando(6)'; }; #Verificar que el modem puede 'ver' el cielo ;
if a=-5	{ z='- Registrando en la red satelital(5)'; }; #Solo se deberia mostrar al encender el equipo;
if a=-4	{ z='- Error en puerto serie(4)'; }; #No esta en modo satelite o el baudrate no es 19200 o el modem esta mal conectado;
if a=-3	{ z='- No hay registros para enviar(3)'; };
if a=-2	{ z='- Error al leer memoria de registros(2)'; }; 
if a=-1	{ z='- Enviando registros(1)'; };
if a=0	{ z='- Listo para enviar(0)'; };
if a>0	{ z='- Registros enviados: ',a; };

#Informa ante un cambio de estado;
if a!b
{
	write_str 35,z,' - Cambio',$13,$10;
	b=a;
};

#Informa cada 30 segundos el estado;
check_timer n {
	n=(m-n)/1000; #/55 En GRD-2G;
	read_io 8,c,0; #Registros en memoria;
	if n<0  { write_str 35,z,' - Proximo: Inmediato. - En memoria:',c,$13,$10; }
	else { write_str 35,z,' - Proximo:',n,' seg. - En memoria:',c,$13,$10; };
	timer n,30000;
};

#Verifica recepcin de strings;
read_str 32,c,z;
if c>0 {
	write_str 35,'- Recepcion: ',z,$13,$10;
};
end;