#Ejemplo FTP - FR - 2015-04-13;
#Sobre Version 5.2.2 o superior;
#Este programa sube un archivo via FTP cada 2 minutos con los valores de los historicos que se estan generando; 

#Uso de variables;
#Numericas temporales: b,d,e,g;
#Texto temporales: v,w;
#a:Estado del programa;
#h:Cantidad de registros a enviar;
#i:Contador de carga de registros;
#j:Estado de GPRS;
#m:Timer para proximo intento;
#t:Timer para timeouts;
#n:Timer para traces;
start
{
	write_str 40,'ftp.exemys.com';			#Carga servidor;
	write_str 41,'user';					#Carga usuario;
	write_str 42,'password';				#Carga contrasea;

	a=0;									#Estado inicial;
	timer m,2000;							#Espera 2 segundos antes de empezar;
	timer n,5000;							#Timer para traces de estado;
};

read_io 10,j,0;								#Lectura de link GPRS;
if j=3										#Si esta conectado a GPRS;
{
	check_timer m
	{
		#ESTADO 0, Desconecta del MW para enviar historicos solo por FTP (Tambien se puede detener el envio de historicos, manteniendo la conexin con el MW con write_io 48,0,1);
		if a=0
		{
			write_io 22,0,0;				#Desconecta del MW;
			write_str 35,'Desconectando del MW',$13,$10;
			a=1;
		};
		#ESTADO 1. Carga del nombre del proximo archivo. Se incrementa cada vez que se sube un archivo nuevo;
		if a=1
		{
			read_io 21,b,1;					#Lee memoria no volatil;
			v=b,'.txt';				
			write_str 43,v;					#Carga nombre del archivo;
			write_str 35,'Proximo archivo: ',v,$13,$10;
			a=2;
		};
		#ESTADO 2. Empieza conexin al servidor FTP;
		if a=2
		{
			write_str 35,'Conectando a servidor FTP',$13,$10;
			write_io 44,0,0;	#Conectar a FTP;
			a=3;
			timer t,30000;		#Timeout de conexin, 30 segundos;
		};
		#ESTADO 3. Verifica conexin con el servidor;
		if a=3
		{
			read_io 47,b,0; 	#Lee estado de FTP;
			if b=10				#Se conecto?;
			{
				write_str 35,'Conectado a servidor FTP',$13,$10;
				a=4;
			}
			else
			{
				check_timer t	#Si se cumple el timeout vuelve al intentar la conexin;
				{
					write_str 35,'No se puedo realizar la conexin',$13,$10;
					timer m,30000;		#Reintento de conexin, 30 segundos;
					a=2;
				};
			};
		};
		#ESTADO 4. Inicio de envio de datos;
		if a=4
		{
			write_str 35,'Inicio envio por FTP',$13,$10;
			read_io 8,h,0; 			#Lee cantidad de historicos en memoria;
			if h>999 { h=1000; };	#Limita en 1000 el numero de registros subidos por conexin;
			i=0;					#'i' es el contador de registros subidos;
			a=5;
		};                                    
		#ESTADO 5. Envia un registros con el formato "hh:mm:ss,dd/mm/aaaa,tipo canal,nro canal,tipo historico,valor(con dos decimales)";
		if a=5
		{
			if i<h	#Carga historicos hasta la cantidad ya determinada;
			{
				write_io 60,0,i; #Lee el historico de la posicin de memoria 'i';
				read_io 61,b,0;		#Carga en b el tipo de canal;
				read_io 62,c,0;		#Carga en c el timestamp;
				read_io 63,d,0;		#Carga en d el tipo de historico;
				read_io 64,e,0;		#Carga en e el numero de canal;
				read_io 65,f,0;		#Carga en f el valor;
				#Arma linea de texto;
				#Arma string hh:mm:ss con el time stamp que se cargue en C, usa G. Sale en V;
				v=''; hs g,c;  if g<10 {v=v,'0';}; v=v,g,':'; min g,c; if g<10 {v=v,'0';}; v=v,g,':'; sec g,c; if g<10 {v=v,'0';}; v=v,g;
				w=v;
				#Arma string dd/mm/aaaa con el time stamp que se cargue en C, usa G. Sale en V;
				v=''; day g,c;  if g<10 {v=v,'0';}; v=v,g,'/'; month g,c; if g<10 {v=v,'0';}; v=v,g,'/'; year g,c; v=v,g;
				point z,f,2;
				w=w,',',v,',',b,',',e,',',d,',',z,$13,$10;
				write_str 45,w; #Carga linea en archivo FTP;
				write_str 35,'Enviando registro: ',w,$13,$10;
				timer t,30000;	
				i=i+1;
				a=6;
			}
			else											#Si se terminaron los historicos cierra el archivo;
			{
				write_io 46,0,0;							#Cierra la conexion FTP para cerrar el archivo;
				write_str 35,'Cerrar conexin FTP',$13,$10;
				timer t,30000;	
				a=7;
			};
		};
		#ESTADO 6. Verifica el envio de un registro;
		if a=6
		{
			read_io 47,b,0;	 #Lee estado de FTP y espera a que se envien los datos;
			if b=10 #Listo para enviar proximo registros;
			{
				a=5;
			}
			else #Timeout, en 30 segundos vuelve a intentar conexin FTP;
			{
				check_timer t
				{
					write_str 35,'Falla envio de registro',$13,$10;
					timer m,30000;
					a=2;
				};
			};
		};
		#ESTADO 7, espera cierre de archivo;
		if a=7
		{
			read_io 47,b,0;							#Lee estado de FTP;
			if b=0									#Si ya se cerro el FTP incrementa el numero de archivo y lo guarda en memoria no volatil;
			{
				write_str 35,'Conexin FTP cerrada',$13,$10;
				write_io 66,0,h;					#Borra la cantidad de historicos h;
				#incrementa el numero de archivo;
				read_io 21,b,1;
				b=b+1;
				write_io 21,1,b;
				#;
				timer m,120000;						#Timer para proximo envio;
				a=1;
			}
			else									#Timeout de cierre, si en 30 segundos no pudo cerrar vuelve al estado inicial;
			{
				check_timer t
				{
					write_str 35,'Falla desconexin de FTP',$13,$10;
					timer m,30000;
					a=2;
				};
			};
		};
	};
};
#Informa cada 5 segundos el estado del programa;
check_timer n {
	n=(m-n)/55;
	write_str 35,'GPRS:',j,' - Estado:',a,' - Proxima accion:',n,' s',$13,$10;
	timer n,5000;
};
end;