#FTP client example - FR - 2015-04-13;
#Firmware 5.2.2 or higher;
#This example shows how to send the historical records to an FTP server; 

start
{
	write_str 40,'ftp.exemys.com';			#Load server's URL;
	write_str 41,'user';					#Load FTP server user;
	write_str 42,'password';				#Load FTP server password;

	a=0;									#Initial state;
	timer m,2000;							#waits 2 seconds to start;
	timer n,5000;							#Timer used to send the state to every 5 seconds;
};

read_io 10,j,0;								#Read GPRS link state;
if j=3										#If attached to GPRS...;
{
	check_timer m
	{
		#STATE 0, Disconnect the GRD from the MW to prevent sending historical records to it (You can also set the GRD to stop sending records to the MW even when connected by calling write_io 48,0,1);
		if a=0
		{
			write_io 22,0,0;				#Disconnect the GRD from the MW;
			write_str 35,'Disconnecting from the MW',$13,$10;
			a=1;
		};
		#STATE 1. Load the next file's name;
		if a=1
		{
			read_io 21,b,1;					#Read it number from non-volatile memory;
			v=b,'.txt';				
			write_str 43,v;					#Loads FTP file name;
			write_str 35,'Next file: ',v,$13,$10;
			a=2;
		};
		#STATE 2. Begin connection to FTP server;
		if a=2
		{
			write_str 35,'Connecting to FTP server',$13,$10;
			write_io 44,0,0;	#Connect to FTP server;
			a=3;
			timer t,30000;		#30 seconds timeout;
		};
		#STATE 3. Check server connection;
		if a=3
		{
			read_io 47,b,0; 	#Read FTP client status;
			if b=10				#Is it connected?;
			{
				write_str 35,'Connected to FTP server',$13,$10;
				a=4;
			}
			else
			{
				check_timer t	#Timeout? -> Retry;
				{
					write_str 35,'Cannot establish connection',$13,$10;
					timer m,30000; #30 seconds to retry;
					a=2;
				};
			};
		};
		#STATE 4. Begin sending records;
		if a=4
		{
			write_str 35,'Begin sending records',$13,$10;
			read_io 8,h,0; 			#Read how many records are in memory;
			if h>999 { h=1000; };	#Limit to 1000 per connection;
			i=0;					#'i' counts sent records;
			a=5;
		};                                    
		#STATE 5. Send record with format "hh:mm:ss,dd/mm/yyyy,channel type,channel address,historical record type,value(with 2 decimals)";
		if a=5
		{
			if i<h	#Still records to send?;
			{
				write_io 60,0,i; #Read record in position 'i';
				read_io 61,b,0;		#Load b with channel type;
				read_io 62,c,0;		#Load c with timestamp;
				read_io 63,d,0;		#Load d with historical record type;
				read_io 64,e,0;		#Load e channel address;
				read_io 65,f,0;		#Load f value;
				#Create record string;
				#Create string with timestamp in format 'hh:mm:ss';
				v=''; hs g,c;  if g<10 {v=v,'0';}; v=v,g,':'; min g,c; if g<10 {v=v,'0';}; v=v,g,':'; sec g,c; if g<10 {v=v,'0';}; v=v,g;
				w=v;
				#Create string with timestamp in format 'dd/mm/yyyy' and attaches it;
				v=''; day g,c;  if g<10 {v=v,'0';}; v=v,g,'/'; month g,c; if g<10 {v=v,'0';}; v=v,g,'/'; year g,c; v=v,g;
				#Attach value with 2 decimals;
				point z,f,2;
				w=w,',',v,',',b,',',e,',',d,',',z,$13,$10;
				write_str 45,w; #Load string with record in FTP client;
				write_str 35,'Sending record: ',w,$13,$10;
				timer t,30000;	
				i=i+1;
				a=6;
			}
			else											#No more records to send. Close file and FTP client;
			{
				write_io 46,0,0;							
				write_str 35,'Closing connection',$13,$10;
				timer t,30000;	
				a=7;
			};
		};
		#STATE 6. Check record sent;
		if a=6
		{
			read_io 47,b,0;	 #Read FTP client status;
			if b=10 #Ready to send next record?;
			{
				a=5;
			}
			else 
			{
				check_timer t #30 seconds time out? Retry;
				{
					write_str 35,'Error while sending register',$13,$10;
					timer m,30000;
					a=2;
				};
			};
		};
		#STATE 7, Wait FTP connection closed;
		if a=7
		{
			read_io 47,b,0; #Read FTP client status;
			if b=0	#If closed...;
			{
				write_str 35,'Connection closed',$13,$10;
				write_io 66,0,h;	#Delete send records from memery;
				#Increment file number and store it in non-volatile memory;
				read_io 21,b,1;
				b=b+1;
				write_io 21,1,b;
				#;
				timer m,120000;	 	#Wait 2 minutes before next try;
				a=1;
			}
			else 
			{
				check_timer t #Timeout while closing?;
				{
					write_str 35,'Disconnection error',$13,$10;
					timer m,30000;
					a=2;
				};
			};
		};
	};
};

#Report script state every 5 seconds to the traces window;
check_timer n {
	n=(m-n)/55;
	write_str 35,'GPRS:',j,' - State:',a,' - Next action:',n,' s',$13,$10;
	timer n,5000;
};
end;