# 2020-07-02 (FR)
# This script shows how to send historical records using a SBD Iridium Modem (ITAS/EDGE) connected to the GRD's serial port;

start
{
	a=0; b=0;
	timer m,1000; #The first try will be done 1 second after running the script;
};

#Reads satelite modem status; 
read_io 55,a,0;	

#Try to send the historical records in memory every 5 minutes;
check_timer m
{
	write_io 54,0,0; #Send historical records using satelite modem;
	timer m,300000;  #Next try in 5 minutes;
};

#The script could end here. The code below is used to send to the Script Programmer's trace console the modem status;
if a!b
{
	if a=-7 { write_str 35,'Can.t send while connected to the Middleware',$13,$10; };
	if a=-6	{ write_str 35,'Error while sending records',$13,$10; };
	if a=-5	{ write_str 35,'Initializing modem',$13,$10; };
	if a=-4	{ write_str 35,'Serial port configuration error',$13,$10; };
	if a=-3	{ write_str 35,'Historical records memory empty',$13,$10; };
	if a=-2	{ write_str 35,'Error while reading historical records memory',$13,$10; }; 
	if a=-1	{ write_str 35,'Sending records',$13,$10; };
	if a=0	{ write_str 35,'Ready to send',$13,$10; };
	if a>0	{ write_str 35,'Records sent: ',a,$13,$10; };
	b=a;
};

#Check string reception;
read_str 32,c,z;
if c>0 {
	write_str 35,'- Received: ',z,$13,$10;
};
end;